// Visual Disturbance Magnet - 内容脚本
// 为页面中部分图片与文字添加视觉扰动效果

(function() {
  'use strict';

  // 检查是否已经注入过样式
  let styleInjected = false;

  // 注入动画样式
  function injectStyles() {
    if (styleInjected) return;
    
    const style = document.createElement('style');
    style.id = 'visual-disturbance-styles';
    style.textContent = `
      @keyframes disturbanceAnimation {
        0% { 
          transform: scale(1) translateY(0); 
          opacity: 1; 
        }
        25% { 
          transform: scale(1.15) translateY(-8px); 
        }
        50% { 
          transform: scale(0.85) translateY(8px); 
          opacity: 0.8; 
        }
        75% { 
          transform: scale(1.1) translateY(-5px); 
        }
        100% { 
          transform: scale(1) translateY(0); 
          opacity: 1; 
        }
      }
      
      .visual-disturbance-active {
        animation: disturbanceAnimation 0.6s infinite !important;
        z-index: 9999 !important;
        position: relative !important;
      }
      
      .plugin-overlay-image {
        animation: none !important;
        transform-origin: top left !important;
        position: fixed !important;
        z-index: 999999 !important;
        pointer-events: none !important;
      }
      
      .plugin-overlay-image.visual-disturbance-active {
        animation: none !important;
      }
    `;
    document.head.appendChild(style);
    styleInjected = true;
  }

  // 为元素添加视觉扰动效果
  function disturbElements() {
    // 注入样式
    injectStyles();

    // 选择候选元素：图片和文字元素（排除插件添加的图片）
    const candidates = [
      ...document.querySelectorAll('img:not(.plugin-overlay-image):not([data-plugin-image])'),
      ...document.querySelectorAll('p'),
      ...document.querySelectorAll('h1, h2, h3, h4, h5, h6'),
      ...document.querySelectorAll('span'),
      ...document.querySelectorAll('a'),
      ...document.querySelectorAll('div[class*="text"], div[class*="content"]')
    ];

    // 过滤掉已经添加了扰动的元素和插件图片
    const availableCandidates = candidates.filter(el => 
      !el.classList.contains('visual-disturbance-active') &&
      !el.classList.contains('plugin-overlay-image') &&
      !el.hasAttribute('data-plugin-image') &&
      el.offsetWidth > 0 && 
      el.offsetHeight > 0
    );

    // 随机选择40%的元素
    const selected = availableCandidates
      .sort(() => 0.5 - Math.random())
      .slice(0, Math.floor(availableCandidates.length * 0.4));

    // 为选中的元素添加扰动效果
    selected.forEach(el => {
      el.classList.add('visual-disturbance-active');
    });

    console.log(`[Visual Disturbance Magnet] 已为 ${selected.length} 个元素添加视觉扰动效果`);
  }

  // 添加图片到页面
  function addImages() {
    // 确保样式已注入
    injectStyles();
    
    const leftImg = document.createElement('img');
    const rightImg = document.createElement('img');
    
    // 获取图片路径
    const leftImgPath = chrome.runtime.getURL('image/left.png');
    const rightImgPath = chrome.runtime.getURL('image/right.png');
    
    // 设置左图
    leftImg.src = leftImgPath;
    leftImg.className = 'plugin-overlay-image';
    leftImg.setAttribute('data-plugin-image', 'left');
    leftImg.style.cssText = 'position: fixed !important; top: 20% !important; left: 10px !important; transform: scale(0.2) !important; transform-origin: top left !important; z-index: 999999 !important; pointer-events: none !important; animation: none !important;';
    
    // 设置右图
    rightImg.src = rightImgPath;
    rightImg.className = 'plugin-overlay-image';
    rightImg.setAttribute('data-plugin-image', 'right');
    rightImg.style.cssText = 'position: fixed !important; top: 20% !important; right: 10px !important; transform: scale(0.3) !important; transform-origin: top right !important; z-index: 999999 !important; pointer-events: none !important; animation: none !important;';
    
    // 添加到页面
    document.body.appendChild(leftImg);
    document.body.appendChild(rightImg);
  }

  // 页面加载完成后自动注入扰动效果
  function init() {
    if (document.readyState === 'loading') {
      document.addEventListener('DOMContentLoaded', () => {
        addImages();
        setTimeout(disturbElements, 500);
      });
    } else {
      addImages();
      setTimeout(disturbElements, 500);
    }
  }

  init();
})();

